/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLantern
extends Block {
    public BlockLantern(String name, int lightLevel) {
        super(Material.field_151573_f);
        float r = 0.0625f;
        float f = 0.375f;
        float f1 = f / 2.0f;
        this.setHarvestLevel("pickaxe", 0);
        Utils.setBlockSound(this, ModSounds.soundLantern);
        Utils.setLightLevel(this, lightLevel);
        this.func_149711_c(3.5f);
        this.func_149752_b(3.5f);
        this.func_149713_g(500);
        this.func_149676_a(0.5f - f1, r * 1.0f, 0.5f - f1, 0.5f + f1, r * 7.0f, 0.5f + f1);
        this.func_149647_a(EtFuturum.creativeTabBlocks);
        this.func_149663_c(Utils.getUnlocalisedName(name));
        this.func_149658_d(name);
        this.func_149713_g(0);
    }

    public void func_149719_a(IBlockAccess worldIn, int x, int y, int z) {
        float r = 0.0625f;
        float f = 0.375f;
        float f1 = f / 2.0f;
        if (worldIn.func_72805_g(x, y, z) == 0) {
            this.func_149676_a(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, r * 7.0f, 0.5f + f1);
        } else {
            this.func_149676_a(0.5f - f1, r * 1.0f, 0.5f - f1, 0.5f + f1, r * 8.0f, 0.5f + f1);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.canPlaceBelow(world, x, y, z) || this.canPlaceAbove(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149742_c(world, x, y, z);
    }

    private boolean canPlaceAbove(World world, int x, int y, int z) {
        Block above = world.func_147439_a(x, y + 1, z);
        int aboveMeta = world.func_72805_g(x, y + 1, z);
        return world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || above == ModBlocks.CHAIN.get() && world.func_72805_g(x, y + 1, z) == 0 || above instanceof BlockFence || above instanceof BlockWall || above instanceof BlockSlab && aboveMeta < 8 || above instanceof BlockStairs && aboveMeta < 4;
    }

    private boolean canPlaceBelow(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).canPlaceTorchOnTop(world, x, y - 1, z) || World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.canPlaceBelow(world, x, y, z) ? 0 : 1;
            }
        }
        return 0;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        this.func_149695_a(world, x, y, z, block);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        super.func_149695_a(worldIn, x, y, z, neighbor);
        if (!this.func_149718_j(worldIn, x, y, z)) {
            this.setLanternToAir(worldIn, x, y, z);
        }
    }

    public void setLanternToAir(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public String func_149702_O() {
        return this.func_149641_N();
    }

    public int func_149645_b() {
        return RenderIDs.LANTERN;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }
}

